/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.cparser;

import com.ibm.hwmca.fw.util.cparser.ParserDataObj;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CparserInt
extends ParserDataObj {
    private boolean byteSwap = true;

    public CparserInt(int dataLength, boolean inValue, Method inMethod, Object invokeObject, boolean skipIfNull) {
        super(dataLength, inMethod, invokeObject, skipIfNull);
        this.setByteSwap(inValue);
    }

    public CparserInt() {
    }

    public void setLength(int inputLength) {
        switch (inputLength) {
            case 1: 
            case 2: 
            case 4: {
                super.setLength(inputLength);
                break;
            }
            default: {
                super.setLength(1);
            }
        }
    }

    public void setByteSwap(boolean inValue) {
        this.byteSwap = inValue;
    }

    public boolean isByteSwap() {
        return this.byteSwap;
    }

    int process(int offset, byte[] inputArray) throws IllegalAccessException, InvocationTargetException {
        int intValue = 0;
        if (this.dataLength + offset > inputArray.length) {
            return inputArray.length;
        }
        intValue = this.isByteSwap() ? CparserInt.toIntSwap(inputArray, this.dataLength, offset) : CparserInt.toInt(inputArray, this.dataLength, offset);
        boolean skipIt = false;
        if (this.isSkipIfNull() && intValue == 0) {
            skipIt = true;
            this.setSkipped(true);
        }
        if (!skipIt) {
            this.methodToCall.invoke(this.objectToInvoke, (Object[])new Integer[]{new Integer(intValue)});
        } else {
            this.setSkipped(true);
        }
        return offset + this.dataLength;
    }
}

